/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.pet_cemetery.client.renderer.entity.UndeadCatRenderer;
import com.teamabnormals.pet_cemetery.client.renderer.entity.UndeadParrotRenderer;
import com.teamabnormals.pet_cemetery.client.renderer.entity.UndeadWolfRenderer;
import com.teamabnormals.pet_cemetery.client.renderer.entity.layers.UndeadParrotOnShoulderLayer;
import com.teamabnormals.pet_cemetery.common.item.PetCollarItem;
import com.teamabnormals.pet_cemetery.core.data.client.PCItemModelProvider;
import com.teamabnormals.pet_cemetery.core.data.client.PCLanguageProvider;
import com.teamabnormals.pet_cemetery.core.data.server.PCAdvancementProvider;
import com.teamabnormals.pet_cemetery.core.data.server.tags.PCEntityTypeTagsProvider;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import com.teamabnormals.pet_cemetery.core.registry.PCItems;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="pet_cemetery")
public class PetCemetery {
    public static final String MOD_ID = "pet_cemetery";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("pet_cemetery");

    public PetCemetery() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::registerRenderers);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayers);
            bus.addListener(this::registerItemColors);
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.m_236039_(event.includeServer(), (DataProvider)new PCEntityTypeTagsProvider(generator, helper));
        generator.m_236039_(event.includeServer(), (DataProvider)new PCAdvancementProvider(generator, helper));
        generator.m_236039_(event.includeClient(), (DataProvider)new PCItemModelProvider(generator, helper));
        generator.m_236039_(event.includeClient(), (DataProvider)new PCLanguageProvider(generator));
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)PCEntityTypes.ZOMBIE_WOLF.get(), UndeadWolfRenderer::new);
        event.registerEntityRenderer((EntityType)PCEntityTypes.ZOMBIE_CAT.get(), UndeadCatRenderer::new);
        event.registerEntityRenderer((EntityType)PCEntityTypes.ZOMBIE_PARROT.get(), UndeadParrotRenderer::new);
        event.registerEntityRenderer((EntityType)PCEntityTypes.SKELETON_WOLF.get(), UndeadWolfRenderer::new);
        event.registerEntityRenderer((EntityType)PCEntityTypes.SKELETON_CAT.get(), UndeadCatRenderer::new);
        event.registerEntityRenderer((EntityType)PCEntityTypes.SKELETON_PARROT.get(), UndeadParrotRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : ((PetCollarItem)stack.m_41720_()).getColor(stack), new ItemLike[]{(ItemLike)PCItems.PET_COLLAR.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayers(EntityRenderersEvent.AddLayers event) {
        event.getSkins().forEach(skin -> {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skin);
            renderer.m_115326_(new UndeadParrotOnShoulderLayer(renderer, event.getEntityModels()));
        });
    }
}

